#version 330
#extension GL_EXT_gpu_shader4 : enable
//Psy flowerMod01.fsh  by  avin  

//https://www.shadertoy.com/view/3djSRt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Big thanks to @BigWings for his youtube videos! 
// Impressed by https://www.youtube.com/watch?v=r1UOB8NVE8I

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (gl_FragCoord.xy - iResolution.xy * 0.5) / iResolution.y;

    vec2 st = vec2(atan(uv.x, uv.y), length(uv));

    float c1 = 0.0;
    float c2 = 0.0;
    float c3 = 0.0;
    float z = 1.0;
    for(float i = 0.0; i <= 3.14; i += 0.314) {
        z *= -1.0;
        uv = vec2(st.x / 6.2831 + i + (sign(z) * iTime * sqrt(i * 5.0) * 0.01), st.y + cos(iTime+i) * 0.02);

        float x = uv.x * 14.0;
        float m = min(fract(x), fract(1.0 - x));
        c1 += smoothstep(0.0, 0.01, m * 0.5 + 0.2 - uv.y*i*.75) * 0.20;
        c2 += sign(z) * smoothstep(0.0, 0.01, m * 0.5  - uv.y*i) * 0.75;
        c3 += sign(z * -1.0) * smoothstep(0.0, 0.01, m * 0.5 + 0.2 - uv.y) * 0.75;
    }

    vec3 col = vec3(fract(c3*.5), fract(c1 +c3), floor(c2 + c1)) ;

    gl_FragColor = vec4(col, 1.0);
}